; =============================================================================
; CRTCV.asm - ColecoVision Slideshow Main File
; =============================================================================
; Main program structure, cartridge header, and slideshow loop.
; =============================================================================

    CPU Z80
    fname "slideshow.rom"

; =============================================================================
; CONSTANTS
; =============================================================================
NMI_FLAG    EQU $7380
VRAM_PATTERN  EQU $0000
VRAM_COLOR    EQU $2000

; =============================================================================
; ROM ORGANIZATION
; =============================================================================
    ORG $8000

; --- ColecoVision ROM Header
    dw $55AA        ; Standard Header
    dw $7200,$7280,0,0      ; Reserved
	; POINTER TO ROM CODE ENTRY POINT
	dw	start
	
	; RST ROUTINES
	; RST 08
	ret
	nop
	nop
	; RST 10
	ret
	nop
	nop
	; RST 18
	ret
	nop
	nop
	; RST 20
	ret
	nop
	nop
	; RST 28
	ret
	nop
	nop
	; RST 30
	ret
	nop
	nop
	; RST 38 ; SPINNER
	ret
	nop
	nop	
	
	; JUMP TO NON MASKABLE ROUTINE
	jp	nmi_handler

    db "WARRIOR SLIDESHOW/NEWCOLECO/2025"

; =============================================================================
; MAIN PROGRAM ENTRY
; =============================================================================
start:
    im 1            ; Interrupt Mode 1
    di              ; Disable interrupts for setup
    call turn_sound_off
    call $1f85      ; DEFAULT COLECOVISION BIOS SCREEN MODE_1 UNCOMMENT THIS IF NO COLECOVISION TITLE SCREEN ACTIVATED
    call clear_ram
    call setup_graphics_mode
    call init_sprites

; =============================================================================
; SLIDESHOW LOOP
; =============================================================================
slideshow_loop:

    call nmioff
    call show_zx0_sprites
    ; --- Show Image 6 (Using ZX0)
    ld  hl, IMG1_PAT
    ld  de, VRAM_PATTERN
    call zx0_decompress

    ld  hl, IMG1_COL
    ld  de, VRAM_COLOR
    call zx0_decompress
    call nmion

    ld  b, 120
    call delay
    call clear_vram


    call nmioff
    call show_dan3_sprites
    ; --- Show Image 1 (Using DAN3)
    ld  hl, IMG2_PAT
    ld  de, VRAM_PATTERN
    call dan3_decompress

    ld  hl, IMG2_COL
    ld  de, VRAM_COLOR
    call dan3_decompress
    call nmion

    ld  b, 120
    call delay
    call clear_vram


    call nmioff
    call show_dan1_sprites
    ; --- Show Image 6 (Using ZX0)
    ld  hl, IMG3_PAT
    ld  de, VRAM_PATTERN
    call dan1_decompress

    ld  hl, IMG3_COL
    ld  de, VRAM_COLOR
    call dan1_decompress
    call nmion

    ld  b, 120
    call delay
    call clear_vram


    call nmioff
    call show_zx7_sprites
    ; --- Show Image 2 (Using ZX7)
    ld  hl, IMG4_PAT    ; HL = Pointer to IMG1 Pattern data
    ld  de, VRAM_PATTERN ; DE = Destination VRAM for pattern
    call zx7_decompress
    
    ld  hl, IMG4_COL    ; HL = Pointer to IMG1 Color data
    ld  de, VRAM_COLOR   ; DE = Destination VRAM for color
    call zx7_decompress
    call nmion
    
    ld  b, 120          ; Delay for ~2 seconds
    call delay
    call clear_vram


    call nmioff
    call show_pletter_sprites
    ; --- Show Image 3 (Using Pletter)
    ld  hl, IMG5_PAT
    ld  de, VRAM_PATTERN
    call pletter_decompress

    ld  hl, IMG5_COL
    ld  de, VRAM_COLOR
    call pletter_decompress
    call nmion

    ld  b, 120
    call delay
    call clear_vram


    call nmioff
    call show_bitbuster_sprites
    ; --- Show Image 6 (Using ZX0)
    ld  hl, IMG6_PAT
    ld  de, VRAM_PATTERN
    call bitbuster_decompress

    ld  hl, IMG6_COL
    ld  de, VRAM_COLOR
    call bitbuster_decompress
    call nmion

    ld  b, 120
    call delay
    call clear_vram


    call nmioff
    call show_lzf_sprites
    ; --- Show Image 4 (Using LZF)
    ld  hl, IMG7_PAT
    ld  de, VRAM_PATTERN
    call lzf_decompress

    ld  hl, IMG7_COL
    ld  de, VRAM_COLOR
    call lzf_decompress
    call nmion

    ld  b, 120
    call delay
    call clear_vram


    call nmioff
    call show_mdkrle_sprites
    ; --- Show Image 5 (Using MDK-RLE)
    ld  hl, IMG8_PAT
    ld  de, VRAM_PATTERN
    call mdkrle_decompress

    ld  hl, IMG8_COL
    ld  de, VRAM_COLOR
    call mdkrle_decompress
    call nmion

    ld  b, 120
    call delay
    call clear_vram


    jp slideshow_loop   ; Repeat

; =============================================================================
; INCLUDE FILES
; =============================================================================
    include "utils.asm"
    include "sprites.asm"
    include "zx0.asm"
    include "dan3.asm"
    include "dan1.asm"
    include "zx7.asm"
    include "pletter.asm"
    include "bitbuster.asm"
    include "lzf.asm"
    include "mdkrle.asm"

; =============================================================================
; IMAGE DATA
; =============================================================================
; Compressed image data will be included here.
; Each image has a pattern and color component.
; Total size must be under 32KB.
; =============================================================================

IMG1_PAT:
    incbin "pattern.zx0"
IMG1_COL:
    incbin "color.zx0"

IMG2_PAT:
    incbin "pattern.dan3"
IMG2_COL:
    incbin "color.dan3"

IMG3_PAT:
    incbin "pattern.dan1"
IMG3_COL:
    incbin "color.dan1"

IMG4_PAT:
    incbin "pattern.zx7"
IMG4_COL:
    incbin "color.zx7"

IMG5_PAT:
    incbin "pattern.plet5"
IMG5_COL:
    incbin "color.plet5"

IMG6_PAT:
    incbin "pattern.pck"
IMG6_COL:
    incbin "color.pck"

IMG7_PAT:
    incbin "pattern.lzf"
IMG7_COL:
    incbin "color.lzf"

IMG8_PAT:
    incbin "pattern.mdk"
IMG8_COL:
    incbin "color.mdk"
