init_sprites:
    ld      de, $3800
    ld      hl, SprPattern_ZX7
    ld      bc, $800
    call    $1fdf       ; WRITE VRAM
    ld      a, 0
    call    $1fc1       ; INIT_SPR_ORDER
    ld      a, 0
    call    $1fc4
    ld      a,$d0  
    out     ($be), a
    ret

show_zx7_sprites:
    ld      hl, SprAttrib_ZX7
    jr      show_sprites

show_pletter_sprites:
    ld      hl, SprAttrib_PLETTER
    jr      show_sprites

show_dan3_sprites:
    ld      hl, SprAttrib_DAN3
    jr      show_sprites

show_lzf_sprites:
    ld      hl, SprAttrib_LZF
    jr      show_sprites

show_mdkrle_sprites:
    ld      hl, SprAttrib_MDKRLE

show_sprites:
    ld      de, ($8002)
    ld      bc, 12
    ldir
    ld      a, 3
    call    $1fc1       ; INIT_SPR_ORDER
    ld      a, 3
    call    $1fc4
    ld      a,$d0  
    out     ($be), a
    ret

SprAttrib_ZX7:
    db      0, 240,  0, 6
    db     16, 240,  4, 6
    db     32, 240,  8, 6

SprAttrib_PLETTER:
    db      0, 240, 12, 6
    db     16, 240, 16, 6
    db     32, 240, 20, 6

SprAttrib_DAN3:
    db      0, 240, 24, 6
    db     16, 240, 28, 6
    db     32, 240, 32, 6

SprAttrib_LZF:
    db      0, 240, 36, 6
    db     16, 240, 40, 6
    db     32, 240, 44, 6

SprAttrib_MDKRLE:
    db      0, 240, 48, 6
    db     16, 240, 52, 6
    db     32, 240, 56, 6    


SprPattern_ZX7:

; Block 01
db 0, 0, 0, 0, 0, 0, 0, 0

; Block 03
db 0, 0, 0, 0, 0, 0, 0, 0

; Block 00
db 97, 81, 73, 69, 67, 0, 99, 20

; Block 02
db 8, 20, 99, 0, 1, 1, 121, 5

; Block 05
db 0, 0, 0, 0, 0, 0, 0, 3

; Block 07
db 1, 0, 1, 3, 3, 3, 3, 0

; Block 04
db 3, 0, 0, 30, 63, 48, 48, 255

; Block 06
db 254, 0, 2, 3, 51, 51, 255, 206

; Block 09
db 0, 1, 3, 3, 3, 3, 1, 0

; Block 0B
db 0, 0, 0, 0, 3, 1, 0, 0

; Block 08
db 0, 2, 3, 51, 51, 255, 206, 0

; Block 0A
db 30, 63, 51, 51, 255, 254, 0, 0


SprPattern_PLETTER:

; Block 01
db 0, 0, 0, 0, 0, 0, 0, 0

; Block 03
db 0, 0, 0, 0, 0, 0, 0, 0

; Block 00
db 127, 9, 9, 9, 6, 0, 127, 64

; Block 02
db 64, 64, 64, 0, 127, 73, 73, 73

; Block 05
db 0, 0, 0, 0, 0, 0, 0, 3

; Block 07
db 1, 0, 1, 3, 3, 3, 3, 0

; Block 04
db 3, 0, 0, 30, 63, 48, 48, 255

; Block 06
db 254, 0, 2, 3, 51, 51, 255, 206

; Block 09
db 0, 1, 3, 3, 3, 3, 1, 0

; Block 0B
db 0, 0, 0, 0, 3, 1, 0, 0

; Block 08
db 0, 2, 3, 51, 51, 255, 206, 0

; Block 0A
db 30, 63, 51, 51, 255, 254, 0, 0


SprPattern_DAN3:

; Block 01
db 0, 0, 0, 0, 0, 0, 0, 0

; Block 03
db 0, 0, 0, 0, 0, 0, 0, 0

; Block 00
db 127, 65, 65, 65, 62, 0, 126, 9

; Block 02
db 9, 9, 126, 0, 127, 3, 28, 96

; Block 05
db 0, 0, 0, 0, 0, 0, 0, 3

; Block 07
db 1, 0, 1, 3, 3, 3, 3, 1

; Block 04
db 127, 0, 0, 30, 63, 48, 48, 255

; Block 06
db 254, 0, 194, 243, 51, 51, 63, 14

; Block 09
db 0, 1, 3, 3, 3, 3, 1, 0

; Block 0B
db 1, 3, 3, 3, 3, 1, 0, 0

; Block 08
db 0, 206, 255, 51, 51, 255, 206, 0

; Block 0A
db 254, 255, 51, 51, 243, 226, 0, 0


SprPattern_LZF:

; Block 01
db 0, 0, 0, 0, 0, 0, 0, 0

; Block 03
db 0, 0, 0, 0, 0, 0, 0, 0

; Block 00
db 127, 64, 64, 64, 64, 0, 97, 81

; Block 02
db 73, 69, 67, 0, 127, 9, 9, 9

; Block 05
db 0, 0, 0, 0, 0, 0, 0, 3

; Block 07
db 1, 0, 1, 3, 3, 3, 3, 1

; Block 04
db 1, 0, 0, 30, 63, 48, 48, 255

; Block 06
db 254, 0, 206, 255, 51, 51, 255, 206

; Block 09
db 0, 1, 3, 3, 3, 3, 1, 0

; Block 0B
db 0, 0, 0, 0, 3, 1, 0, 0

; Block 08
db 0, 254, 255, 3, 3, 255, 254, 0

; Block 0A
db 30, 63, 48, 48, 255, 254, 0, 0


SprPattern_MDKRLE:

; Block 01
db 0, 0, 0, 0, 0, 0, 0, 0

; Block 03
db 0, 0, 0, 0, 0, 0, 0, 0

; Block 00
db 127, 9, 9, 9, 118, 0, 127, 64

; Block 02
db 64, 64, 64, 0, 127, 73, 73, 73

; Block 05
db 0, 0, 0, 1, 3, 3, 3, 3

; Block 07
db 1, 0, 1, 3, 3, 3, 3, 1

; Block 04
db 65, 0, 0, 30, 63, 51, 51, 243

; Block 06
db 226, 0, 14, 63, 51, 51, 243, 194

; Block 09
db 0, 1, 3, 3, 3, 3, 1, 0

; Block 0B
db 1, 3, 3, 3, 3, 1, 0, 0
; Block 08
db 0, 254, 255, 3, 3, 255, 254, 0

; Block 0A
db 2, 3, 51, 51, 255, 206, 0, 0
