FNAME "mob_obj_graphics_i.bin"
CPU Z80
ORG $8000
include "Coleco_Include.asm"
SPRITE_NAME:			EQU		7100h	;Pointer to sprite attributes name table
	; max 32 sprites * 4 bytes each = 128 bytes
SPRITE_ORDER:			EQU		7190h	;Pointer to sprite order table
	; max 32 sprites
WORK_BUFFER:			EQU		8006h	;9000h	;Pointer to graphics work area
	; up to around 300h max usage
CONTROLLER_BUFFER:		EQU		72E0h	;Pointer to hand controller input area
	;12 bytes
TIMER_TABLE:			EQU		77ACh	;Pointer to timers table
	;16 timers
TIMER_DATA_BLOCK:		EQU		77DCh	;Pointer to timers table for long timers
ACTIVATE:				EQU 	1FF7h
PUT_OBJECT:				EQU 	1FFAh
PUT_FRAME:				EQU 	080Bh
PUTMOBILEOS:			EQU 	0A98h
STATUS:					EQU 	6300h
STATUSFM:				EQU 	6300h
STATUSX:				EQU 	6301h
STATUSY:				EQU 	6303h
STATUSNG:				EQU		6305h
;If OLD_SCREEN is < 7000h it is assumed to reside in VRAM
OLD_SCREEN:				EQU 	3000h
YDISP:					EQU		0
XDISP:					EQU		1
FLAGS:					EQU		3
FRM:					EQU		4
F_GEN:					EQU		5 	;Name of 1st generator in object's gen table
XP_OS:					EQU		6 	;X_PAT_POS of OLD_SCREEN
YP_OS:					EQU		7 	;Y_PAT_POS of OLD_SCREEN
YP_BK:					EQU		18
XP_BK:					EQU		17
BK_PTN:					EQU 	28 	;Start of background pattern generators ; 1Ch
OBJ_PTN:				EQU 	100 	;Start of object's pattern generators ; 64h
BK_CLR:					EQU 	132 	;Start of background color generators ; 84h
;
PX_TO_PTRN_POS:			EQU	07E8H
GET_BKGRND:				EQU	0898H
PM2:					EQU	0AEBH
MODE:					EQU 0
NEW_GEN:				EQU	5000h
FIRST_GEN_NAME:			EQU	0096h
;
DefPatternTable:		EQU	0h
DefNameTable:			EQU	1800h
DefSprAttrTable:		EQU	1b00h
DefColorTable:			EQU	2000h
DefSprPatTable:			EQU	3800h
;
; Tables
	DB	055h,0aah	;Magic number -- means skip intro, reverse for traditional
        ;DB	0aah,055h	;Magic number -- means show 10 sec title screen
	DW	7100h		;SPRITE_NAME	;Pointer to sprite name table
	DW	7190h		;SPRITE_ORDER	;Pointer to sprite order table
	DW	9000h		;WORK_BUFFER	;Pointer to graphics tempory work area
	DW	77ACh		;CONTROLLER_BUFFER	;Pointer to hand controler input area
	DW	MAIN_PROG	;Entry point to game
; Vectors
	JP	RST08		;Restart 8
	JP	RST10		;Restart 10h
	JP	RST18		;Restart 18h
	JP	RST20		;Restart 20h
	JP	RST28		;Restart 28h
	JP	RST30		;Restart 30h
	JP	MASK_INT	;Maskable interrupt (used by spinner)
	JP	VDPINT		;NMI interrupt (used by VDP 60 times per second)
; Title screen name
	DB	'MOBILE OBJECT',1eh,1fh
	DB	'/TELEMETRY'
	DB	'/2019'
	;1dh is copyright symbol
	;1eh,1fh is trade mark symbol
;Pointer to DCB (Device Control Block)
DEV_ID:	DB	8	;Default DEVICE_ID but check for B from boot block

; Implementation of vectors
	RST08:
	RST10:
	RST18:
	RST20:
	RST28:
	RST30:
	RET
MASK_INT:
	RETI	;Used with spinner: steering wheel, 
		;super action, roller controller
VDPINT:
	PUSH	AF
	PUSH	BC
	PUSH	DE
	PUSH	HL
	PUSH	IX
	PUSH	IY
	EX		AF,AF'
	PUSH	AF
	EXX
	PUSH	BC
	PUSH	DE
	PUSH	HL
	LD		A,(SECOND_TIMER)
    CALL	TEST_SIGNAL
	OR		A
	JR		Z,.6
	LD 		A,(STATUSFM)
	INC		A
	CP		3
	JR		NZ,.1
	LD 		A,0
	JR		.3
.1:
	CP		131
	JR		NZ,.3
	LD 		A,128
.3:
	LD 		(STATUSFM),A
.6:
	LD 		A,(STATUSX)
	INC 	A
	LD  	(STATUSX),A
	LD 		IX,MOB
	LD 		HL,GRAPHICS
	LD 		B,MODE
	CALL 	PUTMOBILE
	CALL	TIME_MGR
;Now restore everything
	POP		HL
	POP		DE
	POP		BC
	EXX
	POP		AF
	EX		AF,AF'
	POP		IY
	POP		IX
	POP		HL
	POP		DE
	POP		BC
;
	IN		A,(0BFh)	;Side effect allows another NMI to happen
;
	POP		AF
;
	RETN	;Non maskable interrupt used for:
;
MAIN_PROG:
	IM 		1
	CALL	MODE_1
	CALL	CLEAR_VRAM
	CALL	LOAD_ASCII
; Initialize Timers
	LD		HL,TIMER_TABLE
	LD		DE,TIMER_DATA_BLOCK
	CALL	INIT_TIMER
;--------------------------------------------------------
; Enable timers
	CALL	CREATE_TIMERS
	LD 		HL,0060h
	LD  	(STATUSX),HL
	LD  	(STATUSY),HL
;
	LD      A,31h			;fill with 1's
	LD      HL,1800h		;pattern name table
	LD      DE,0300h
	CALL	FILL_VRAM
;
	LD      A,081h
	LD      DE,32
	LD      HL,2000h		;pattern color table
	CALL    FILL_VRAM
;
	LD      HL,MOB
	SCF     
	CALL    ACTIVATE
;
	LD      BC,01E0h
	CALL    WRITE_REGISTER
LOOP:
	JP      LOOP
;--------------------------------------------------------
;
; PUTMOBILE version GRAPHICS MODE I
;
;IX,MOB
;	0 - GRAPHICS address
;	2 - STATUS address
;		0 - Frame
;		1 - X Location
;		3 - Y Location
;		5 - NEWGEN address
;	4 - OLD_SCREEN address
;	6 - FIRST_GEN_NAME value
;HL,GRAPHICS
;	0 - OBJ_TYPE (Mobile Object = 1)
;	1 - NUMGEN
;	2 - NEWGEN address
;	4 - GENERATORS address
;	6 - FRAME_0 address
;	8 - FRAME_1 address
;B,MODE
;	0 = additive
;	1 = 
;IY,WORK_BUFFER
;WORK_BUFFER+0 = Y Location
;WORK_BUFFER+1 = X Location
;WORK_BUFFER+2 = Color
;WORK_BUFFER+3 = MODE
;WORK_BUFFER+4 = FRAME
;WORK_BUFFER+5 = F_GEN
;WORK_BUFFER+6 = XP_OS
;WORK_BUFFER+7 = YP_OS
;WORK_BUFFER+17 = XP_BRK
;WORK_BUFFER+18 = YP_BRK
;WORK_BUFFER+28 = BK_PTN
;WORK_BUFFER+100 = OBJ_PTN
;WORK_BUFFER+132 = BK_CLR
PUTMOBILE: 
		LD		IY,(8006h)
		RES		7,B
		LD		(IY+FLAGS),B 	;save MODE
		PUSH	HL				;store pointer to GRAPHICS
		LD		H,(IX+003h)
		LD		L,(IX+002h)		;get address of STATUS area
		LD		A,(HL)			;get current FRAME from STATUS area
		LD		(IY+FRM),A 		;save FRAME in WORK_BUFFER
		XOR		080h				;XOR value of FRAME with 80h
		LD		(HL),A 			;save back in STATUS area
		INC		HL				;increment STATUS area to X Location low
		LD		E,(HL)			;store in E register
		LD		A,E 			;load into A register
		AND		007h				;AND X Location low with 7
		NEG						;get NEG of that value
		ADD		A,008h 			;ADD 8
; from next pat boundary
		LD		(IY+XDISP),A 	;save that value at WORK_BUFFER+1
		INC		HL				;increment STATUS area to X Location high
		LD		D,(HL)			;store in D register
		CALL	PX_TO_PTRN_POS
		LD		(IY+XP_BK),E
		INC		HL				;increment STATUS area to Y Location low
		LD		E,(HL)			;store in E register
		LD		A,E 			;load into A register
		AND		007h			;AND Y Location low with 7
		LD		(IY+YDISP),A 	;save that value at WORK_BUFFER+0
		INC		HL				;increment STATUS area to Y Location high
		LD		D,(HL)			;store in D register
		CALL	PX_TO_PTRN_POS
		LD		(IY+YP_BK),E
; Now get the nine names that constitute the
; background on which the mobile object will
; be superimposed
PM1:
		LD		HL,(WORK_BUFFER)
		LD		DE,YP_BK+1
		ADD		HL,DE
		LD		D,(IY+YP_BK)
		LD		E,(IY+XP_BK)
		LD		BC,0303h
		CALL	GET_BKGRND
; Read old screen into buffer and get COLOR
; and FIRST_GEN_NAME
		LD 		IX,MOB
		ld 		d,(ix+005H) 		; DE := OLD_SCREEN address
		ld 		e,(ix+004H)
		ld 		a,(ix+006H) 		; Get FIRST_GEN_NAME
		pop 	ix 			; IX := Address of graphics
		CALL	PM2				; Call rest of OS PUT_MOBILE routine
		LD 		IX,MOB
		LD		IY,3			; Set up for 3 item VRAM write
		LD		A,(IX+6)		; Get FIRST_GEN_NAME
		LD		B,A				; And save another copy
		AND		A,7				; Evaluate MOD 8
		CP		7				; If not equal 7 then
		JR		NZ,THREE_GEN 	; 3 generators to move
		LD		IY,4			; Else, move 4 generators
THREE_GEN:
	LD		A,B				; A := FIRST_GEN_NAME
	SRL		A				; Divide by 8
	SRL		A
	SRL		A
	LD		E,A				; DE gets pointer to object's
	LD		D,0				; color gens in VRAM
	LD		HL,9000h+88h 	; Point to 4th gen
	PUSH	HL				; Save pointer
	LD		A,(HL)
	LD		B,3				; Copy this generator 3 times
COPY3:
	INC		HL
	LD		(HL),A
	DJNZ 	COPY3
	POP		HL				; Get back pointer
	LD		A,4				; Code for color table
;ENTRY:	 A table code to act on
;        DE start index is a two-byte number indicating the starting entry of table
;        HL data
;        IY count
;
	JP		PUT_VRAM
;--------------------------------------------------------
CREATE_TIMERS:
    LD		HL,(AMERICA)
	LD		H,0
	LD		A,1
	CALL	REQUEST_SIGNAL
	LD		(SECOND_TIMER),A
	RET
SECOND_TIMER:
	DS	1
;--------------------------------------------------------
CLEAR_VRAM:
	XOR		A
	LD		DE, $4000
	LD		HL, $0000
	JP		FILL_VRAM
;--------------------------------------------------------
MOB:
	DW	GRAPHICS		;address of GRAPHICS structure
	DW	STATUS			;address of STATUS structure
	DW	OLD_SCREEN		;address of OLD_SCREEN
	DW	FIRST_GEN_NAME	;address of FIRST_GEN_NAME
GRAPHICS:
	DB	01h				;type of object
	DB	0ch				;number of GENERATORS
	DW	NEW_GEN			;address of NEW_GEN
	DW	GENERATORS		;address of GENERATORS
	DW	FRAME0			;address of FRAME0
	DW	FRAME1			;address of FRAME1
	DW	FRAME2			;address of FRAME2
FRAME0:
	DB	00h,01h,02h,03h,040h
FRAME1:
	DB	04h,05h,06h,07h,030h
FRAME2:
	DB	08h,09h,0ah,0bh,0D0h
GENERATORS:
;// FRAME 0 ////////////////////////////
;   // upper left
    DB 00000000b,00000111b,00011111b,00111111b,00111111b,01111110b,01111100b,01111000b   
 ;  // lower right
    DB 01111100b,01111110b,00111111b,00111111b,00011111b,00000111b,00000000b,00000000b
;   // upper right
    DB 00000000b,11000000b,11000000b,10000000b,00000000b,00000000b,00000000b,00000000b
;   // lower right
    DB 00000000b,00000000b,00000000b,10000000b,11000000b,11000000b,00000000b,00000000b
;// FRAME 1 ////////////////////////////
;   // upper left
    DB 00000000b,00000111b,00011111b,00111111b,00111111b,01111111b,01111111b,01111000b
;   // lower left
    DB 01111111b,01111111b,00111111b,00111111b,00011111b,00000111b,00000000b,00000000b
;   // upper right
    DB 00000000b,11000000b,11110000b,11111000b,11111000b,11100000b,00000000b,00000000b
;   // lower right
    DB 00000000b,11100000b,11111000b,11111000b,11110000b,11000000b,00000000b,00000000
;// FRAME 2 ////////////////////////////
;   // upper left
    DB 00000000b,00000111b,00011111b,00111111b,00111111b,01111111b,01111111b,01111111b
;   // lower left
    DB 01111111b,01111111b,00111111b,00111111b,00011111b,00000111b,00000000b,00000000b
;   // upper right
    DB 00000000b,11000000b,11110000b,11111000b,11111000b,11111100b,11111100b,11111100b
;   // lower right
    DB 11111100b,11111100b,11111000b,11111000b,11110000b,11000000b,00000000b,00000000b
;