/**
 * @file font.c
 * @author John Wohlers (jhon@wohlershome.net)
 * @brief Font for ADAMfarkle
 * @date 2022-02-22
 * 
 * @copyright Copyright (c) 2022
 * 
 */

#include "font.h"
#include <msx.h>
#include <sys/ioctl.h>



// PATTERNS //////////////////////////////////////////////////////////////////
static const char fnt[] =
  {
	0x00,0x1F,0x3F,0x70,0x60,0x60,0x60,0x60, // 0x80 upper left corner  
	0x00,0xF8,0xFC,0x0E,0x06,0x06,0x06,0x06, // 0x81 upper right corner 
	0x60,0x60,0x60,0x60,0x70,0x3F,0x1F,0x00, // 0x82 lower left corner  
	0x06,0x06,0x06,0x06,0x0E,0xFC,0xF8,0x00, // 0x83 lower right corner 
	0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00, // 0x84 top line           
	0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00, // 0x85 bottom line        
	0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60, // 0x86 left line
	0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06, // 0x87 right line

	0x00,0x07,0x0F,0x1F,0x3F,0x07,0x07,0x0F, // 0x88 Upper half logo (1,1)
	0x00,0xF0,0xF0,0xF9,0xFB,0XFC,0xBC,0x3C, // 0x89 (1,2)
	0x00,0x7F,0xFF,0xFF,0xFF,0x78,0x78,0x78, // 0x8A (1,3)
	0x00,0xF8,0xF8,0xFC,0xFD,0x7C,0x3C,0x3C, // 0x8B (1,4)
	0x00,0x3F,0x7F,0xFF,0xFF,0x3F,0x3D,0x79, // 0x8C (1,5)
	0x00,0x07,0x0F,0x9F,0xBF,0xC7,0xC7,0xE7, // 0x8D (1,6)
	0x00,0xF0,0xF0,0xF8,0xF8,0xFD,0xFD,0xFF, // 0x8E (1,7)
	0x00,0x7E,0x7E,0xFE,0xFE,0xFE,0xFE,0xFE, // 0x8F (1,8)

	0x0F,0x1F,0x1F,0x3F,0x3F,0x78,0xF0,0x00, // 0x90 LOWER HALF LOGO (2,1)
	0x1C,0xFE,0xFE,0xFF,0xFF,0x0F,0x07,0x00, // 0x91 (2,2)
	0x78,0x78,0x78,0x78,0x7F,0xFF,0xFF,0x00, // 0x92 (2,3)
	0x3C,0x3C,0x3C,0x7D,0xFD,0xFB,0xF7,0x00, // 0x93 (2,4)
	0x78,0xFF,0xFF,0xFF,0xFF,0xE0,0xC0,0x00, // 0x94 (2,5)
	0xE7,0xF7,0xF7,0xF7,0xFF,0x7F,0x3F,0x00, // 0x95 (2,6)
	0xBF,0xBF,0x9F,0x9F,0x8F,0x8F,0x87,0x00, // 0x96 (2,7)
	0xDE,0xDE,0xDE,0x9E,0x9E,0x9E,0x1E,0x00, // 0x97 (2,8)
	
	0x10,0x28,0x44,0x10,0x28,0x44,0x00,0x00, // 0x98 LESS Indicator
	0x00,0x00,0x44,0x28,0x10,0x44,0x28,0x10, // 0x99 MORE Indicator
	0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA, // 0x9A Disabled Field
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 0x9B Future
	0x00,0x38,0x44,0xBA,0xBA,0xBA,0x44,0x38, // 0x9C Radio - Selected
	0x00,0x38,0x44,0x82,0x82,0x82,0x44,0x38, // 0x9D Radio - Un-selected
	0xFE,0x82,0x82,0x82,0x82,0x82,0xFE,0x00, // 0x9E Check Box - Unchecked
	0xFE,0xC6,0xAA,0x92,0xAA,0xC6,0xFE,0x00, // 0x9F Check Box - Checked

	0x00,0x00,0x00,0x00,0x03,0x07,0x0F,0x0F, // 0xA0 Die Upper Left
	0x00,0x00,0x00,0x00,0xC0,0xE0,0xF0,0xF0, // 0xA1 Die Upper Right
	0x0F,0x0F,0x07,0x03,0x00,0x00,0x00,0x00, // 0xA2 Die Lower Left
	0xF0,0xF0,0xE0,0xC0,0x00,0x00,0x00,0x00, // 0xA3 Die Lower Right
	0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF, // 0xA4 Die Top
	0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00, // 0xA5 Die Bottom
	0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F, // 0xA6 Die Left
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0, // 0xA7 Die Right

	0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00, // 0xA8 Die Pip 1
	0xC0,0xC0,0x00,0x00,0x00,0x00,0x03,0x03, // 0xA9 Die Pip 2
	0xC0,0xC0,0x00,0x18,0x18,0x00,0x03,0x03, // 0xAA Die Pip 3
	0xC3,0xC3,0x00,0x00,0x00,0x00,0xC3,0xC3, // 0xAB Die Pip 4
	0xC3,0xC3,0x00,0x18,0x18,0x00,0xC3,0xC3, // 0xAC Die Pip 5
	0xC3,0xC3,0x00,0xC3,0xC3,0x00,0xC3,0xC3, // 0xAD Die Pip 6
	0x7C,0x82,0x82,0x92,0x82,0x82,0x7C,0x00, // 0xAE Mini-Die 1
	0x7C,0x82,0xA2,0x82,0x8A,0x82,0x7C,0x00, // 0xAF Mini-Die 2

	0x3F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7F, // 0xB0 Upper Half FARKLE Logo
	0xFC,0xFE,0xFE,0x0E,0xE0,0xF0,0xF0,0x7E, // 0xB1
	0x00,0x00,0x00,0x00,0x00,0x6E,0x7F,0x7F, // 0xB2
	0x00,0x00,0x00,0x00,0x00,0x30,0x73,0xF7, // 0xB3
	0x00,0x00,0x38,0x38,0x38,0x38,0xB8,0xB9, // 0xB4
	0x00,0x00,0x00,0x00,0x00,0x70,0xFC,0xCC, // 0xB5

	0x7E,0x7C,0x7C,0x7C,0x7D,0x7D,0x01,0x00, // 0xB6 Lower Half FARKLE Logo
	0xFF,0xC7,0x3F,0xFF,0xC7,0xE7,0xFF,0x7B, // 0xB7
	0x79,0x70,0x70,0x70,0x70,0x70,0x00,0x00, // 0xB8
	0xFF,0x7E,0x7C,0x7E,0x7F,0x77,0x71,0x00, // 0xB9
	0x73,0x77,0x77,0x77,0x77,0xF3,0x81,0x00, // 0xBA
	0x8C,0xFC,0xF8,0x00,0x98,0xF8,0xF0,0x00, // 0xBB
  };

/**
 * @brief Load Font into UDG space
 * 
 */
void setupFont(void)
{
    void *param = &fnt;
    console_ioctl(IOCTL_GENCON_SET_UDGS,&param);  // load charaters
}