	'
	' Demo of graphics for CVBasic
	'
	' by Oscar Toledo G.
	'
	' Creation date: Mar/08/2024.
	' Revision date: Aug/06/2024. Added endless loop.
	' Revision date: Aug/26/2025. Adapted for NES.
	'

	DIM x(32),y(32),col(32),col2(32)

	PALETTE LOAD demo_palette

	WHILE 1

	CLS

	SCREEN portrait_pattern,0,260,8,8,8

	GOSUB small_wait

	RESTORE message_1

	GOSUB show_message

	GOSUB small_wait
	
	FOR c = 0 TO 7
		WAIT
		WAIT
		#c = 260 + c * 32
		SCREEN spaces,0,#c,8,1
		SCREEN portrait_pattern,0,#c+32,8,8,8
	NEXT c

	FOR c = 0 TO 7
		WAIT
		WAIT
		#c = 516 + c
		SCREEN spaces,0,#c,1,8,1
		SCREEN portrait_pattern,0,#c+1,8,8,8
	NEXT c

	RESTORE message_2

	GOSUB show_message

	GOSUB small_wait
	
	FOR c = 0 TO 144
		WAIT
		SPRITE 0,$A0,c,$01,0
		SPRITE 1,$A0,c+8,$03,0
	NEXT c

	RESTORE message_3

	GOSUB show_message

	GOSUB small_wait

	FOR c = 0 TO 31
		x(c) = RANDOM(176)
		y(c) = RANDOM(240)
		col(c) = c % 3 * 4
		col2(c) = (c / 3) % 4
		SPRITE c * 2,y(c),x(c),col(c) + 1,col2(c)
		SPRITE c * 2 + 1,y(c),x(c) + 8,col(c) + 3,col2(c)
	NEXT c

	FOR c = 0 TO 240
		WAIT
		FOR d = 0 TO 15
			SPRITE d * 2,y(d),x(d),col(d) + 1,col2(d)
			SPRITE d * 2 + 1,y(d),x(d) + 8,col(d) + 3,col2(d)
			y(d) = y(d) + 1
			IF y(d) = $c0 THEN y(d) = $f1
		NEXT d
		FOR d = 16 TO 31
			SPRITE d * 2,y(d),x(d),col(d) + 1,col2(d)
			SPRITE d * 2 + 1,y(d),x(d) + 8,col(d) + 3,col2(d)
			x(d) = x(d) + 1
			IF x(d) = $ff THEN x(d) = $00
		NEXT d
	NEXT c

	FOR c = 0 TO 63
		SPRITE c,$f0,0,0,0
	NEXT c
		
	RESTORE message_4

	GOSUB show_message

	GOSUB small_wait

	WEND

demo_palette:
	DATA BYTE $0F,$26,$27,$30
	DATA BYTE $0F,$26,$27,$30
	DATA BYTE $0F,$26,$27,$30
	DATA BYTE $0F,$26,$27,$30
	DATA BYTE $0F,$21,$22,$23
	DATA BYTE $0F,$24,$25,$26
	DATA BYTE $0F,$27,$28,$29
	DATA BYTE $0F,$2A,$2B,$2C

spaces:
	DATA BYTE $20,$00,$20,$00,$20,$00,$20,$00,$20,$00,$20,$00,$20,$00,$20,$00

small_wait:	PROCEDURE
	FOR c = 0 TO 60
		WAIT
	NEXT c
	END

show_message:	PROCEDURE

	'
	' Erase area.
	'
	FOR #position = $210e TO $21ee STEP 32
		FOR #c = 0 TO $11
			VPOKE #position + #c, 32
		NEXT #c
	NEXT #position

	'
	' Draw message.
	'
	#position = $2000 + 270
	DO
		READ BYTE d
		IF d = $0D THEN
			#position = ((#position + 32) AND $FFe0) + $000e
		ELSEIF d <> 0 THEN
			VPOKE #position, d
			#position = #position + 1
		END IF
		WAIT
	LOOP WHILE d

	END

message_1:
	DATA BYTE "Hi! This is a",$0d
	DATA BYTE "CVBasic demo",$0d
	DATA BYTE "program.",$00

message_2:
	DATA BYTE "You can displace",$0d
	DATA BYTE "graphics moving",$0d
	DATA BYTE "tiles on the",$0d
	DATA BYTE "screen instead of",$0d
	DATA BYTE "graphic data.",$00

message_3:
	DATA BYTE "Sprites can",$0d
	DATA BYTE "overlay",$0d
	DATA BYTE "background",$0d
	DATA BYTE "graphics.",$00

message_4:
	DATA BYTE "I hope you",$0d
	DATA BYTE "enjoyed the",$0d
	DATA BYTE "demo.",$00

	CHRROM 0 PATTERN 256

	BITMAP "1111111111111111"
	BITMAP "1111111111111111"
	BITMAP "1111111111111111"
	BITMAP "1111111111111111"
	BITMAP "1111111111111111"
	BITMAP "1111111111111111"
	BITMAP "1111111111111111"
	BITMAP "1111111111111111"
	BITMAP "1111111111111111"
	BITMAP "1111111111111111"
	BITMAP "1111111111111111"
	BITMAP "1111111111111111"
	BITMAP "1111111111111111"
	BITMAP "1111111111111111"
	BITMAP "1111111111111111"
	BITMAP "1111111111111111"

	BITMAP "2222222222222222"
	BITMAP "2222222222222222"
	BITMAP "2222222222222222"
	BITMAP "2222222222222222"
	BITMAP "2222222222222222"
	BITMAP "2222222222222222"
	BITMAP "2222222222222222"
	BITMAP "2222222222222222"
	BITMAP "2222222222222222"
	BITMAP "2222222222222222"
	BITMAP "2222222222222222"
	BITMAP "2222222222222222"
	BITMAP "2222222222222222"
	BITMAP "2222222222222222"
	BITMAP "2222222222222222"
	BITMAP "2222222222222222"

	BITMAP "3333333333333333"
	BITMAP "3333333333333333"
	BITMAP "3333333333333333"
	BITMAP "3333333333333333"
	BITMAP "3333333333333333"
	BITMAP "3333333333333333"
	BITMAP "3333333333333333"
	BITMAP "3333333333333333"
	BITMAP "3333333333333333"
	BITMAP "3333333333333333"
	BITMAP "3333333333333333"
	BITMAP "3333333333333333"
	BITMAP "3333333333333333"
	BITMAP "3333333333333333"
	BITMAP "3333333333333333"
	BITMAP "3333333333333333"

	' TMSColor 3.2 Aug/26/2025
	' Command: ../tmscolor/tmscolor -nes -t128 -b portrait_nes.png portrait_nes.bas 
	' Created: Tue Aug 26 10:55:48 2025

	' Start tile = 128. Total_tiles = 52
	CHRROM 0 PATTERN 128
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000111"
	BITMAP "00111111"
	BITMAP "11111111"
	BITMAP "11111110"
	BITMAP "11001100"

	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "11100000"
	BITMAP "11100000"
	BITMAP "11110000"
	BITMAP "11110000"
	BITMAP "11111000"

	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000002"
	BITMAP "00000022"
	BITMAP "00000222"
	BITMAP "00002222"
	BITMAP "00022222"

	BITMAP "00222222"
	BITMAP "02222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"

	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"

	BITMAP "00000000"
	BITMAP "20000000"
	BITMAP "22200000"
	BITMAP "22220000"
	BITMAP "22222000"
	BITMAP "22222200"
	BITMAP "22222220"
	BITMAP "22222220"

	BITMAP "11101110"
	BITMAP "11101110"
	BITMAP "00000000"
	BITMAP "11101110"
	BITMAP "11101110"
	BITMAP "00000000"
	BITMAP "11101110"
	BITMAP "11101110"

	BITMAP "10011111"
	BITMAP "11111111"
	BITMAP "11111111"
	BITMAP "11000000"
	BITMAP "10011111"
	BITMAP "11111111"
	BITMAP "11111110"
	BITMAP "11001000"

	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11111000"

	BITMAP "00222222"
	BITMAP "00222222"
	BITMAP "02222222"
	BITMAP "02222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22322222"

	BITMAP "22222220"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"

	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "20000000"
	BITMAP "20000000"
	BITMAP "20000000"
	BITMAP "20000000"
	BITMAP "22000000"

	BITMAP "00000000"
	BITMAP "11101110"
	BITMAP "11101110"
	BITMAP "00000000"
	BITMAP "11101110"
	BITMAP "11101110"
	BITMAP "00000000"
	BITMAP "11101110"

	BITMAP "11010111"
	BITMAP "11111111"
	BITMAP "11111111"
	BITMAP "11111000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"

	BITMAP "11110000"
	BITMAP "11000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"

	BITMAP "23333333"
	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "33333332"

	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "32223222"
	BITMAP "32233222"
	BITMAP "32233322"
	BITMAP "21000000"

	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "21010222"
	BITMAP "10101222"

	BITMAP "22000000"
	BITMAP "22000000"
	BITMAP "22000000"
	BITMAP "22000000"
	BITMAP "22000000"
	BITMAP "22000000"
	BITMAP "22000000"
	BITMAP "22000000"

	BITMAP "11101110"
	BITMAP "00000000"
	BITMAP "11101110"
	BITMAP "11101110"
	BITMAP "00000000"
	BITMAP "11101110"
	BITMAP "11101110"
	BITMAP "00000000"

	BITMAP "00000000"
	BITMAP "00011111"
	BITMAP "11111111"
	BITMAP "11111111"
	BITMAP "11111111"
	BITMAP "11110001"
	BITMAP "10001111"
	BITMAP "11111111"

	BITMAP "00000000"
	BITMAP "11110000"
	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11111000"

	BITMAP "32200000"
	BITMAP "22211111"
	BITMAP "22211111"
	BITMAP "22211111"
	BITMAP "22211111"
	BITMAP "22211111"
	BITMAP "22221111"
	BITMAP "22221111"

	BITMAP "11111111"
	BITMAP "11111111"
	BITMAP "01111111"
	BITMAP "01111111"
	BITMAP "01111111"
	BITMAP "01111111"
	BITMAP "01111111"
	BITMAP "00111111"

	BITMAP "11010222"
	BITMAP "10101222"
	BITMAP "11010222"
	BITMAP "11101222"
	BITMAP "11010222"
	BITMAP "11101222"
	BITMAP "11010222"
	BITMAP "11101222"

	BITMAP "11111101"
	BITMAP "10000001"
	BITMAP "11111111"
	BITMAP "11111111"
	BITMAP "11000000"
	BITMAP "11111111"
	BITMAP "11111111"
	BITMAP "11111111"

	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11111000"
	BITMAP "11100000"
	BITMAP "10000000"

	BITMAP "22222111"
	BITMAP "22222211"
	BITMAP "22222211"
	BITMAP "22222221"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "32222222"

	BITMAP "11111111"
	BITMAP "11111111"
	BITMAP "00000111"
	BITMAP "00000111"
	BITMAP "10001111"
	BITMAP "11111100"
	BITMAP "21111100"
	BITMAP "22111100"

	BITMAP "11010222"
	BITMAP "11101222"
	BITMAP "11010222"
	BITMAP "10100222"
	BITMAP "11000222"
	BITMAP "01001223"
	BITMAP "00010223"
	BITMAP "01101233"

	BITMAP "11111100"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"

	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"

	BITMAP "32222222"
	BITMAP "32222222"
	BITMAP "32222222"
	BITMAP "32222222"
	BITMAP "32222222"
	BITMAP "32222222"
	BITMAP "32222222"
	BITMAP "32222222"

	BITMAP "22111111"
	BITMAP "22200000"
	BITMAP "22222211"
	BITMAP "22222211"
	BITMAP "22222211"
	BITMAP "22221211"
	BITMAP "00000011"
	BITMAP "02020211"

	BITMAP "01010233"
	BITMAP "10101233"
	BITMAP "01010233"
	BITMAP "10101233"
	BITMAP "11010232"
	BITMAP "11101232"
	BITMAP "11111232"
	BITMAP "11111232"

	BITMAP "22000000"
	BITMAP "22000000"
	BITMAP "22000000"
	BITMAP "22000000"
	BITMAP "22000000"
	BITMAP "22200000"
	BITMAP "22200000"
	BITMAP "22200000"

	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000003"
	BITMAP "00003333"

	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "00000030"
	BITMAP "00003333"
	BITMAP "00333333"
	BITMAP "03333333"
	BITMAP "33333333"
	BITMAP "33333333"

	BITMAP "32222222"
	BITMAP "32222222"
	BITMAP "32222222"
	BITMAP "32222220"
	BITMAP "32222220"
	BITMAP "32222223"
	BITMAP "32222233"
	BITMAP "32222233"

	BITMAP "00202011"
	BITMAP "20020201"
	BITMAP "20202000"
	BITMAP "02020233"
	BITMAP "20202033"
	BITMAP "02020233"
	BITMAP "20202033"
	BITMAP "02020232"

	BITMAP "11111232"
	BITMAP "11111222"
	BITMAP "11111222"
	BITMAP "11111222"
	BITMAP "00000222"
	BITMAP "02020222"
	BITMAP "20200222"
	BITMAP "02020222"

	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222222"
	BITMAP "22222233"
	BITMAP "22222333"
	BITMAP "22223333"
	BITMAP "22333333"

	BITMAP "22200000"
	BITMAP "22333333"
	BITMAP "23333333"
	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "33333333"

	BITMAP "00000000"
	BITMAP "00000000"
	BITMAP "33300000"
	BITMAP "33333000"
	BITMAP "33333300"
	BITMAP "33333330"
	BITMAP "33333333"
	BITMAP "33333333"

	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "30303030"
	BITMAP "03030303"
	BITMAP "30303030"
	BITMAP "03030303"

	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "03333333"
	BITMAP "30333333"
	BITMAP "03333333"
	BITMAP "33333333"
	BITMAP "03333333"

	BITMAP "32222233"
	BITMAP "33222233"
	BITMAP "33333330"
	BITMAP "33333332"
	BITMAP "30303030"
	BITMAP "03030302"
	BITMAP "30303020"
	BITMAP "03030202"

	BITMAP "20202320"
	BITMAP "02020202"
	BITMAP "20202020"
	BITMAP "02020202"
	BITMAP "20202020"
	BITMAP "02020202"
	BITMAP "20202023"
	BITMAP "02020233"

	BITMAP "20202022"
	BITMAP "02020022"
	BITMAP "20203333"
	BITMAP "02033333"
	BITMAP "23333333"
	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "33333333"

	BITMAP "22333333"
	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "33333303"
	BITMAP "33333030"
	BITMAP "33030303"
	BITMAP "30303030"
	BITMAP "03030303"

	BITMAP "33333033"
	BITMAP "33030303"
	BITMAP "30303030"
	BITMAP "03030303"
	BITMAP "30303030"
	BITMAP "03030303"
	BITMAP "30303030"
	BITMAP "03030303"

	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "33333333"
	BITMAP "03333333"
	BITMAP "30333333"
	BITMAP "03033333"
	BITMAP "30303333"
	BITMAP "03033333"


	' Width = 8, height = 8
portrait_pattern:
	DATA BYTE $80,$81,$82,$83,$84,$85,$86,$86
	DATA BYTE $87,$88,$89,$84,$84,$8a,$8b,$8c
	DATA BYTE $8d,$8e,$8f,$90,$91,$84,$92,$93
	DATA BYTE $94,$95,$96,$97,$98,$84,$92,$86
	DATA BYTE $99,$9a,$9b,$9c,$9d,$84,$92,$8c
	DATA BYTE $9e,$9f,$a0,$a1,$a2,$84,$a3,$93
	DATA BYTE $a4,$a5,$a6,$a7,$a8,$a9,$aa,$ab
	DATA BYTE $ac,$ad,$ae,$af,$b0,$b1,$b2,$b3
